/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.ValueModifyingPower;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Tuple;

public class ModifyDamageTakenPower
extends ValueModifyingPower {
    private final Predicate<Tuple<DamageSource, Float>> condition;
    private Consumer<LivingEntity> attackerAction;
    private Consumer<LivingEntity> selfAction;

    public ModifyDamageTakenPower(PowerType<?> type, PlayerEntity player, Predicate<Tuple<DamageSource, Float>> condition) {
        super(type, player);
        this.condition = condition;
    }

    public boolean doesApply(DamageSource source, float damageAmount) {
        return this.condition.test((Tuple<DamageSource, Float>)new Tuple((Object)source, (Object)Float.valueOf(damageAmount)));
    }

    public void setAttackerAction(Consumer<LivingEntity> attackerAction) {
        this.attackerAction = attackerAction;
    }

    public void setSelfAction(Consumer<LivingEntity> selfAction) {
        this.selfAction = selfAction;
    }

    public void executeActions(Entity attacker) {
        if (this.selfAction != null) {
            this.selfAction.accept((LivingEntity)this.player);
        }
        if (this.attackerAction != null && attacker instanceof LivingEntity) {
            this.attackerAction.accept((LivingEntity)attacker);
        }
    }
}

